
import gurobi

def solve_train_seating_problem():
    # Create a new model
    model = gurobi.Model()

    # Decision Variables
    x1 = model.addVar(lb=100, name="first_class_seats")  # At least 100 first-class seats
    x2 = model.addVar(name="second_class_seats")

    # Objective Function: Maximize profit
    model.setObjective(75 * x1 + 50 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 500, name="total_passengers")  # Total passengers constraint
    model.addConstr(x2 >= 2 * x1, name="second_class_preference")  # Second-class preference constraint

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal first-class seats: {x1.varValue}")
        print(f"Optimal second-class seats: {x2.varValue}")
        print(f"Max Profit: ${75 * x1.varValue + 50 * x2.varValue}")
    else:
        print("The model is infeasible.")

if __name__ == "__main__":
    solve_train_seating_problem()
