
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Tropical_Fruit_Optimization")

# Create decision variables
x = m.addVar(lb=0, name="Pineapples")  # Acres of pineapples
y = m.addVar(lb=0, name="Bananas")  # Acres of bananas

# Set objective function
m.setObjective(200*x + 150*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 200, "Land_Availability")
m.addConstr(y <= 4*x, "Banana_Pineapple_Ratio")
m.addConstr(x >= 40, "Min_Pineapples")
m.addConstr(y >= 60, "Min_Bananas")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Pineapples: {x.x} acres")
    print(f"Bananas: {y.x} acres")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

