
from gurobipy import *

# Create a new model
m = Model("Tropical_Farmer")

# Define the decision variables
P = m.addVar(lb=40, name="Pineapples")  # Minimum 40 acres of pineapples
B = m.addVar(lb=60, name="Bananas")    # Minimum 60 acres of bananas

# Objective function: Maximize profit
m.setObjective(200*P + 150*B, GRB.MAXIMIZE)

# Constraints
m.addConstr(P + B <= 200, "Total_Land")  # Total land constraint
m.addConstr(B <= 4*P, "Banana_to_Pineapple_Ratio")  # Banana to pineapple ratio

# Optimize the model
m.optimize()

# Print results if the model is optimal
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Pineapples: {P.x} acres")
    print(f"Bananas: {B.x} acres")
    print(f"Total Profit: ${m.objVal}")
else:
    print("No optimal solution found.")
