
import gurobi

def solve_farmer_problem():
    # Create a new model
    m = gurobi.Model()

    # Variables
    P = m.addVar(lb=0, name="Pineapples")
    B = m.addVar(lb=0, name="Bananas")

    # Objective function: Maximize profit
    m.setObjective(200 * P + 150 * B, gurobi.GRB.MAXIMIZE)

    # Constraints
    m.addConstr(P + B <= 200, name="Total_Land")
    m.addConstr(B <= 4 * P, name="Banana_to_Pineapple_Ratio")
    m.addConstr(P >= 40, name="Minimum_Pineapples")
    m.addConstr(B >= 60, name="Minimum_Bananas")

    # Update model
    m.update()

    # Solve the model
    m.optimize()

    # Print solution
    if m.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres for Pineapples: {P.varValue}")
        print(f"Optimal acres for Bananas: {B.varValue}")
        print(f"Maximum profit: ${200 * P.varValue + 150 * B.varValue}")
    else:
        print("The model is infeasible.")

solve_farmer_problem()
