
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
dale_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale_hours")
paul_hours = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="paul_hours")
laura_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura_hours")
jean_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean_hours")


# Set objective function
m.setObjective(5 * dale_hours + 2 * paul_hours + 5 * laura_hours + 3 * jean_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(11 * dale_hours + 7 * paul_hours + 3 * jean_hours >= 16)
m.addConstr(1 * paul_hours + 5 * laura_hours + 10 * jean_hours >= 14)
m.addConstr(9 * dale_hours + 7 * jean_hours >= 12)
m.addConstr(9 * dale_hours + 10 * paul_hours >= 21)
m.addConstr(10 * paul_hours + 1 * laura_hours >= 13)
m.addConstr(-7 * laura_hours + 1 * jean_hours >= 0)
m.addConstr(7 * paul_hours + 3 * jean_hours <= 81)
m.addConstr(11 * dale_hours + 3 * jean_hours <= 43)
m.addConstr(7 * paul_hours + 7 * laura_hours <= 31)
m.addConstr(7 * paul_hours + 7 * laura_hours + 3 * jean_hours <= 90)
m.addConstr(11 * dale_hours + 7 * paul_hours + 3 * jean_hours <= 23)
m.addConstr(11 * dale_hours + 7 * paul_hours + 7 * laura_hours + 3 * jean_hours <= 23)
m.addConstr(1 * paul_hours + 10 * jean_hours <= 38)
m.addConstr(1 * paul_hours + 5 * laura_hours <= 33)
m.addConstr(4 * dale_hours + 10 * jean_hours <= 55)
m.addConstr(4 * dale_hours + 1 * paul_hours + 10 * jean_hours <= 32)
m.addConstr(4 * dale_hours + 1 * paul_hours + 5 * laura_hours + 10 * jean_hours <= 32)
m.addConstr(1 * laura_hours + 7 * jean_hours <= 42)
m.addConstr(10 * paul_hours + 1 * laura_hours + 7 * jean_hours <= 49)
m.addConstr(9 * dale_hours + 10 * paul_hours + 7 * jean_hours <= 92)
m.addConstr(9 * dale_hours + 1 * laura_hours + 7 * jean_hours <= 59)
m.addConstr(9 * dale_hours + 10 * paul_hours + 1 * laura_hours <= 50)
m.addConstr(9 * dale_hours + 10 * paul_hours + 1 * laura_hours + 7 * jean_hours <= 50)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

