
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0) # hours worked by Dale
x1 = m.addVar(name="x1", lb=0, integrality=gp.GRB.INTEGER) # hours worked by Paul
x2 = m.addVar(name="x2", lb=0) # hours worked by Laura
x3 = m.addVar(name="x3", lb=0) # hours worked by Jean

# Define the objective function
m.setObjective(5 * x0 + 2 * x1 + 5 * x2 + 3 * x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(11 * x0 + 7 * x1 + 3 * x3 >= 16)
m.addConstr(1 * x1 + 5 * x2 + 10 * x3 >= 14)
m.addConstr(9 * x0 + 7 * x3 >= 12)
m.addConstr(9 * x0 + 10 * x1 >= 21)
m.addConstr(10 * x1 + 1 * x2 >= 13)
m.addConstr(-7 * x2 + 1 * x3 >= 0)
m.addConstr(7 * x1 + 3 * x3 <= 81)
m.addConstr(11 * x0 + 3 * x3 <= 43)
m.addConstr(7 * x1 + 7 * x2 <= 31)
m.addConstr(11 * x0 + 7 * x1 + 7 * x2 + 3 * x3 <= 90)
m.addConstr(11 * x0 + 7 * x1 + 3 * x3 <= 23)
m.addConstr(11 * x0 + 7 * x1 + 7 * x2 + 3 * x3 <= 23)
m.addConstr(1 * x1 + 10 * x3 <= 38)
m.addConstr(1 * x1 + 5 * x2 <= 33)
m.addConstr(4 * x0 + 10 * x3 <= 55)
m.addConstr(4 * x0 + 1 * x1 + 10 * x3 <= 32)
m.addConstr(4 * x0 + 1 * x1 + 5 * x2 + 10 * x3 <= 32)
m.addConstr(1 * x2 + 7 * x3 <= 42)
m.addConstr(10 * x1 + 1 * x2 + 7 * x3 <= 49)
m.addConstr(9 * x0 + 10 * x1 + 7 * x3 <= 92)
m.addConstr(9 * x0 + 1 * x2 + 7 * x3 <= 59)
m.addConstr(9 * x0 + 10 * x1 + 1 * x2 <= 50)
m.addConstr(9 * x0 + 10 * x1 + 1 * x2 + 7 * x3 <= 50)

# Solve the model
m.optimize()

# Print the solution
print("Objective: ", m.objVal)
print("x0: ", x0.varValue)
print("x1: ", x1.varValue)
print("x2: ", x2.varValue)
print("x3: ", x3.varValue)

# Symbolic representation
print("Symbolic Representation:")
print("Variables: ")
print([('x0', 'hours worked by Dale'), ('x1', 'hours worked by Paul'), ('x2', 'hours worked by Laura'), ('x3', 'hours worked by Jean')])
print("Objective Function: 5*x0 + 2*x1 + 5*x2 + 3*x3")
print("Constraints: ")
print([
    "11*x0 + 7*x1 + 3*x3 >= 16",
    "1*x1 + 5*x2 + 10*x3 >= 14",
    "9*x0 + 7*x3 >= 12",
    "9*x0 + 10*x1 >= 21",
    "10*x1 + 1*x2 >= 13",
    "-7*x2 + 1*x3 >= 0",
    "7*x1 + 3*x3 <= 81",
    "11*x0 + 3*x3 <= 43",
    "7*x1 + 7*x2 <= 31",
    "11*x0 + 7*x1 + 7*x2 + 3*x3 <= 90",
    "11*x0 + 7*x1 + 3*x3 <= 23",
    "11*x0 + 7*x1 + 7*x2 + 3*x3 <= 23",
    "1*x1 + 10*x3 <= 38",
    "1*x1 + 5*x2 <= 33",
    "4*x0 + 10*x3 <= 55",
    "4*x0 + 1*x1 + 10*x3 <= 32",
    "4*x0 + 1*x1 + 5*x2 + 10*x3 <= 32",
    "1*x2 + 7*x3 <= 42",
    "10*x1 + 1*x2 + 7*x3 <= 49",
    "9*x0 + 10*x1 + 7*x3 <= 92",
    "9*x0 + 1*x2 + 7*x3 <= 59",
    "9*x0 + 10*x1 + 1*x2 <= 50",
    "9*x0 + 10*x1 + 1*x2 + 7*x3 <= 50"
])

