
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0")  # hours worked by Jean
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1")  # hours worked by Bobby
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2")  # hours worked by John


    # Set objective function
    m.setObjective(6*x0 + 9*x1 + 1*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(11.52*x0 + 4.15*x1 + 10.69*x2 >= 37)
    m.addConstr(0.66*x0 + 12.98*x1 + 0.6*x2 >= 83)
    m.addConstr(3.8*x0 + 2.18*x1 >= 19)
    m.addConstr(4.15*x1 + 10.69*x2 <= 78)
    m.addConstr(11.52*x0 + 4.15*x1 <= 134)
    m.addConstr(11.52*x0 + 4.15*x1 + 10.69*x2 <= 134)
    m.addConstr(12.98*x1 + 0.6*x2 <= 239)
    m.addConstr(0.66*x0 + 0.6*x2 <= 134)
    m.addConstr(0.66*x0 + 12.98*x1 + 0.6*x2 <= 219)
    m.addConstr(3.8*x0 + 2.18*x1 <= 61)
    m.addConstr(2.18*x1 + 4.38*x2 <= 90)
    m.addConstr(3.8*x0 + 2.18*x1 + 4.38*x2 <= 89)

    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
