
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Jean
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Bobby
    x2 = model.addVar(name="x2", lb=0)  # hours worked by John

    # Define the objective function
    model.setObjective(6 * x0 + 9 * x1 + 1 * x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(11.52 * x0 + 4.15 * x1 + 10.69 * x2 >= 37)
    model.addConstr(0.66 * x0 + 12.98 * x1 + 0.6 * x2 >= 83)
    model.addConstr(3.8 * x0 + 2.18 * x1 >= 19)
    model.addConstr(4.15 * x1 + 10.69 * x2 <= 78)
    model.addConstr(11.52 * x0 + 4.15 * x1 <= 134)
    model.addConstr(11.52 * x0 + 4.15 * x1 + 10.69 * x2 <= 134)
    model.addConstr(12.98 * x1 + 0.6 * x2 <= 239)
    model.addConstr(0.66 * x0 + 0.6 * x2 <= 134)
    model.addConstr(0.66 * x0 + 12.98 * x1 + 0.6 * x2 <= 219)
    model.addConstr(3.8 * x0 + 2.18 * x1 <= 61)
    model.addConstr(2.18 * x1 + 4.38 * x2 <= 90)
    model.addConstr(3.8 * x0 + 2.18 * x1 + 4.38 * x2 <= 89)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Jean: ", x0.varValue)
        print("Hours worked by Bobby: ", x1.varValue)
        print("Hours worked by John: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
