
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milligrams_of_iron")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="grams_of_protein")


    # Set objective function
    m.setObjective(3*x0 + 2*x1, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(4*x0 + 6*x1 >= 14, "c1")
    m.addConstr(11*x0 + 7*x1 >= 48, "c2")
    m.addConstr(15*x0 + 15*x1 >= 26, "c3")
    m.addConstr(2*x0 + 14*x1 >= 22, "c4")
    m.addConstr(8*x0 + 12*x1 >= 30, "c5")
    m.addConstr(x0 - 5*x1 >= 0, "c6")
    m.addConstr(4*x0 + 6*x1 <= 32, "c7")
    m.addConstr(11*x0 + 7*x1 <= 95, "c8")
    m.addConstr(15*x0 + 15*x1 <= 37, "c9")
    m.addConstr(2*x0 + 14*x1 <= 35, "c10")
    m.addConstr(8*x0 + 12*x1 <= 67, "c11")



    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('milligrams_of_iron:', x0.x)
        print('grams_of_protein:', x1.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
