
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="milligrams_of_iron", lb=0)  # Assuming non-negative
x2 = model.addVar(name="grams_of_protein", lb=0)  # Assuming non-negative

# Define the objective function
model.setObjective(3 * x1 + 2 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(4 * x1 + 6 * x2 >= 14, name="muscle_growth_index")
model.addConstr(11 * x1 + 7 * x2 >= 48, name="cognitive_performance_index")
model.addConstr(15 * x1 + 15 * x2 >= 26, name="cardiovascular_support_index")
model.addConstr(2 * x1 + 14 * x2 >= 22, name="kidney_support_index")
model.addConstr(8 * x1 + 12 * x2 >= 30, name="digestive_support_index")
model.addConstr(x1 - 5 * x2 >= 0, name="iron_protein_balance")
model.addConstr(4 * x1 + 6 * x2 <= 32, name="muscle_growth_index_max")
model.addConstr(11 * x1 + 7 * x2 <= 95, name="cognitive_performance_index_max")
model.addConstr(15 * x1 + 15 * x2 <= 37, name="cardiovascular_support_index_max")
model.addConstr(2 * x1 + 14 * x2 <= 35, name="kidney_support_index_max")
model.addConstr(8 * x1 + 12 * x2 <= 67, name="digestive_support_index_max")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of iron: {x1.varValue}")
    print(f"Grams of protein: {x2.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
