
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    bobby_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby_hours")
    dale_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale_hours")


    # Set objective function
    model.setObjective(2.71 * bobby_hours + 4.52 * dale_hours, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(2 * bobby_hours + 6 * dale_hours >= 13, "work_quality_min")
    model.addConstr(2 * bobby_hours + 6 * dale_hours <= 25, "work_quality_max")
    model.addConstr(7 * bobby_hours + 2 * dale_hours >= 9, "productivity_min")
    model.addConstr(7 * bobby_hours + 2 * dale_hours <= 20, "productivity_max")
    model.addConstr(-7 * bobby_hours + 5 * dale_hours >= 0, "additional_constraint")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Hours worked by Bobby: {bobby_hours.x}")
        print(f"Hours worked by Dale: {dale_hours.x}")
        print(f"Objective Value: {model.objVal}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
