
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Add variables
x1 = m.addVar(lb=0, name="hours_worked_by_Bobby")
x2 = m.addVar(lb=0, name="hours_worked_by_Dale")

# Set the objective function
m.setObjective(2.71*x1 + 4.52*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x1 + 6*x2 >= 13, "work_quality_rating_min")
m.addConstr(2*x1 + 6*x2 <= 25, "work_quality_rating_max")
m.addConstr(7*x1 + 2*x2 >= 9, "productivity_rating_min")
m.addConstr(7*x1 + 2*x2 <= 20, "productivity_rating_max")
m.addConstr(-7*x1 + 5*x2 >= 0, "additional_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Bobby: {x1.x}")
    print(f"Hours worked by Dale: {x2.x}")
else:
    print("No optimal solution found")
