
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="hours_worked_by_Bobby", lb=0)  
x2 = model.addVar(name="hours_worked_by_Dale", lb=0)

# Define the objective function
model.setObjective(2.71 * x1 + 4.52 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(2 * x1 + 6 * x2 >= 13, name="work_quality_rating")
model.addConstr(7 * x1 + 2 * x2 >= 9, name="productivity_rating")
model.addConstr(-7 * x1 + 5 * x2 >= 0, name="productivity_vs_quality")
model.addConstr(2 * x1 + 6 * x2 <= 25, name="max_work_quality_rating")
model.addConstr(7 * x1 + 2 * x2 <= 20, name="max_productivity_rating")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Bobby: {x1.varValue}")
    print(f"Hours worked by Dale: {x2.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
