
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_e = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_e")  # Integer constraint
    vitamin_b9 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b9")

    # Set objective function
    m.setObjective(4.45 * vitamin_e + 1.29 * vitamin_b9, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(1 * vitamin_e + 7 * vitamin_b9 >= 21, "c0")  # Cognitive performance index
    m.addConstr(2 * vitamin_e + 2 * vitamin_b9 >= 20, "c1")  # Muscle growth index
    m.addConstr(-3 * vitamin_e + 6 * vitamin_b9 >= 0, "c2")
    m.addConstr(1 * vitamin_e + 7 * vitamin_b9 <= 47, "c3")  # Cognitive performance index upper bound
    m.addConstr(2 * vitamin_e + 2 * vitamin_b9 <= 28, "c4")  # Muscle growth index upper bound


    # Optimize model
    m.optimize()

    # Print solution
    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal solution found:")
        print(f"  Milligrams of Vitamin E: {vitamin_e.x}")
        print(f"  Milligrams of Vitamin B9: {vitamin_b9.x}")
        print(f"  Objective Value: {m.objVal}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("Model is infeasible.")
    else:
        print(f"Optimization terminated with status {m.status}.")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
