
from gurobipy import *

# Create a new model
model = Model("Vitamin_Optimization")

# Add variables
x1 = model.addVar(vtype=GRB.INTEGER, name="vitamin_e")
x2 = model.addVar(vtype=GRB.CONTINUOUS, name="vitamin_b9")

# Set the objective function
model.setObjective(4.45*x1 + 1.29*x2, GRB.MINIMIZE)

# Add constraints
model.addConstr(x1 + 7*x2 >= 21, "cognitive_performance_min")
model.addConstr(2*x1 + 2*x2 >= 20, "muscle_growth_min")
model.addConstr(-3*x1 + 6*x2 >= 0, "vitamin_balance")
model.addConstr(x1 + 7*x2 <= 47, "cognitive_performance_max")
model.addConstr(2*x1 + 2*x2 <= 28, "muscle_growth_max")

# Optimize the model
model.optimize()

# Print solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Vitamin E (mg): {x1.x}")
    print(f"Vitamin B9 (mg): {x2.x}")
else:
    print("No optimal solution found")
