
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER, lb=0)  # milligrams of vitamin E
    x2 = model.addVar(name="x2", vtype=gurobi.GRB.CONTINUOUS, lb=0)  # milligrams of vitamin B9

    # Define the objective function
    model.setObjective(4.45 * x1 + 1.29 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(x1 + 7 * x2 >= 21, name="cognitive_performance_index")
    model.addConstr(2 * x1 + 2 * x2 >= 20, name="muscle_growth_index_min")
    model.addConstr(-3 * x1 + 6 * x2 >= 0, name="vitamin_constraint")
    model.addConstr(x1 + 7 * x2 <= 47, name="cognitive_performance_index_max")
    model.addConstr(2 * x1 + 2 * x2 <= 28, name="muscle_growth_index_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin E: {x1.varValue}")
        print(f"Milligrams of vitamin B9: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
