
from gurobipy import Model, GRB

# Create a new model
model = Model("carbohydrate_optimization")

# Create variables
potatoes = model.addVar(vtype=GRB.INTEGER, name="potatoes")
cherry_pies = model.addVar(vtype=GRB.INTEGER, name="cherry_pies")
rotisserie_chickens = model.addVar(vtype=GRB.INTEGER, name="rotisserie_chickens")
cantaloupes = model.addVar(vtype=GRB.INTEGER, name="cantaloupes")

# Set objective function
model.setObjective(6*potatoes**2 + 7*potatoes*rotisserie_chickens + 5*cherry_pies**2 + 4*cherry_pies*rotisserie_chickens + 2*rotisserie_chickens**2 + 6*rotisserie_chickens*cantaloupes + 5*cantaloupes**2 + potatoes, GRB.MAXIMIZE)

# Add constraints
model.addConstr(13*potatoes + 10*cherry_pies + 11*rotisserie_chickens + 2*cantaloupes <= 46, "total_carbohydrates")
model.addConstr(13*potatoes + 2*cantaloupes <= 21, "potatoes_cantaloupes_carbohydrates")
model.addConstr(13*potatoes + 10*cherry_pies <= 46, "potatoes_cherry_pies_carbohydrates")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('potatoes:', potatoes.x)
    print('cherry_pies:', cherry_pies.x)
    print('rotisserie_chickens:', rotisserie_chickens.x)
    print('cantaloupes:', cantaloupes.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

