
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x1 = m.addVar(vtype=GRB.INTEGER, name="potatoes")
x2 = m.addVar(vtype=GRB.INTEGER, name="cherry_pies")
x3 = m.addVar(vtype=GRB.INTEGER, name="rotisserie_chickens")
x4 = m.addVar(vtype=GRB.INTEGER, name="cantaloupes")

# Set the objective function
m.setObjective(6*x1**2 + 7*x1*x3 + 5*x2**2 + 4*x2*x3 + 2*x3**2 + 6*x3*x4 + 5*x4**2 + x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(13*x1 + 2*x4 <= 21, name="Carbs_from_Potatoes_and_Cantaloupes")
m.addConstr(13*x1 + 10*x2 <= 46, name="Carbs_from_Potatoes_and_Cherry_Pies")
m.addConstr(13*x1 + 10*x2 + 11*x3 + 2*x4 <= 46, name="Total_Carbs")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
else:
    print("No optimal solution found")
