
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define variables
x1 = m.addVar(name='potatoes', vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name='cherry_pies', vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name='rotisserie_chickens', vtype=gurobi.GRB.INTEGER)
x4 = m.addVar(name='cantaloupes', vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(6*x1**2 + 7*x1*x3 + 5*x2**2 + 4*x2*x3 + 2*x3**2 + 6*x3*x4 + 5*x4**2 + x1, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(13*x1 + 2*x4 <= 21)
m.addConstr(13*x1 + 10*x2 <= 46)
m.addConstr(13*x1 + 10*x2 + 11*x3 + 2*x4 <= 46)

# Optimize
m.optimize()

# Print solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('Potatoes: ', x1.varValue)
    print('Cherry Pies: ', x2.varValue)
    print('Rotisserie Chickens: ', x3.varValue)
    print('Cantaloupes: ', x4.varValue)
else:
    print('No optimal solution found')
