
from gurobipy import *

# Create a model
m = Model("Nutrition_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="carbohydrates")
x2 = m.addVar(vtype=GRB.INTEGER, name="fiber")  # Must be whole number
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="vitamin_e")
x4 = m.addVar(vtype=GRB.CONTINUOUS, name="vitamin_b6")
x5 = m.addVar(vtype=GRB.CONTINUOUS, name="iron")

# Objective function
m.setObjective(7*x1 + 5*x2 + 3*x3 + 2*x4 + x5, GRB.MAXIMIZE)

# Constraints (adding a few examples)
m.addConstr(x2 + x3 <= 11, "energy_stability")
m.addConstr(x3 + x5 <= 141, "digestive_support")
m.addConstr(x1 + x5 <= 17, "immune_support")

# Solve the model
m.optimize()

# Print solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Obj:", m.objVal)
