
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin B12
    x2 = model.addVar(name="x2", lb=0)  # milligrams of vitamin B7

    # Define the objective function
    model.setObjective(9.14 * x1 + 5.53 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(11 * x1 + 10 * x2 >= 23, name="cardiovascular_support_index_min")
    model.addConstr(12 * x1 + 3 * x2 >= 16, name="energy_stability_index_min")
    model.addConstr(4 * x1 - 3 * x2 >= 0, name="vitamin_B12_B7_relation")
    model.addConstr(11 * x1 + 10 * x2 <= 49, name="cardiovascular_support_index_max")
    model.addConstr(12 * x1 + 3 * x2 <= 50, name="energy_stability_index_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B12: {x1.varValue}")
        print(f"Milligrams of vitamin B7: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
