
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(5, lb=0.0, ub=gp.GRB.INFINITY, vtype=gp.GRB.CONTINUOUS, name=["chicken drumsticks", "oranges", "blueberry pies", "cherry pies", "strips of bacon"])


# Set objective function
m.setObjective(5.07 * x[0] + 4.94 * x[1] + 3.54 * x[2] + 7.76 * x[3] + 2.12 * x[4], gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(13 * x[0] + 22 * x[3] >= 42)
m.addConstr(11 * x[2] + 13 * x[4] >= 48)
m.addConstr(16 * x[1] + 13 * x[4] >= 67)
m.addConstr(16 * x[1] + 22 * x[3] >= 46)
m.addConstr(13 * x[0] + 16 * x[1] + 13 * x[4] >= 71)
m.addConstr(13 * x[0] + 16 * x[1] + 11 * x[2] >= 71)
m.addConstr(13 * x[0] + 16 * x[1] + 13 * x[4] >= 78)
m.addConstr(13 * x[0] + 16 * x[1] + 11 * x[2] >= 78)
m.addConstr(13 * x[0] + 16 * x[1] + 11 * x[2] + 22 * x[3] + 13 * x[4] >= 78)
m.addConstr(17 * x[1] + 4 * x[4] >= 49)
m.addConstr(14 * x[0] + 4 * x[4] >= 52)
m.addConstr(27 * x[2] + 23 * x[3] >= 34)
# ... (rest of the constraints)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

