
import gurobi

def create_and_solve_model():
    m = gurobi.Model()
    x0 = m.addVar(name="chicken_drumsticks", lb=0)
    x1 = m.addVar(name="oranges", lb=0)
    x2 = m.addVar(name="blueberry_pies", lb=0)
    x3 = m.addVar(name="cherry_pies", lb=0)
    x4 = m.addVar(name="strips_of_bacon", lb=0)

    m.setObjective(5.07 * x0 + 4.94 * x1 + 3.54 * x2 + 7.76 * x3 + 2.12 * x4, gurobi.GRB.MINIMIZE)

    # Carbohydrates Constraints
    m.addConstr(13 * x0 + 16 * x1 + 11 * x2 + 22 * x3 + 13 * x4 <= 405)
    m.addConstr(13 * x0 + 22 * x3 >= 42)
    m.addConstr(11 * x2 + 13 * x4 >= 48)
    m.addConstr(16 * x1 + 13 * x4 >= 67)
    m.addConstr(16 * x1 + 22 * x3 >= 46)
    m.addConstr(13 * x0 + 16 * x1 + 13 * x4 >= 71)
    m.addConstr(13 * x0 + 16 * x1 + 11 * x2 >= 71)
    m.addConstr(13 * x0 + 16 * x1 + 13 * x4 >= 78)
    m.addConstr(13 * x0 + 16 * x1 + 11 * x2 >= 78)
    m.addConstr(13 * x0 + 16 * x1 + 11 * x2 + 22 * x3 + 13 * x4 >= 78)

    # Umami Index Constraints
    m.addConstr(17 * x1 + 4 * x4 >= 49)
    m.addConstr(14 * x0 + 4 * x4 >= 52)
    m.addConstr(27 * x2 + 23 * x3 >= 34)
    m.addConstr(23 * x3 + 4 * x4 >= 62)
    m.addConstr(27 * x2 + 4 * x4 >= 32)
    m.addConstr(17 * x1 + 27 * x2 >= 32)
    m.addConstr(14 * x0 + 17 * x1 >= 40)
    m.addConstr(17 * x1 + 23 * x3 + 4 * x4 >= 33)
    m.addConstr(14 * x0 + 17 * x1 + 4 * x4 >= 33)
    m.addConstr(17 * x1 + 27 * x2 + 23 * x3 >= 33)
    m.addConstr(17 * x1 + 23 * x3 + 4 * x4 >= 50)
    m.addConstr(14 * x0 + 17 * x1 + 4 * x4 >= 50)

    # Fat Constraints
    m.addConstr(10 * x2 + 3 * x3 >= 33)
    m.addConstr(3 * x3 + 4 * x4 >= 41)
    m.addConstr(28 * x0 + 18 * x1 + 10 * x2 + 3 * x3 + 4 * x4 >= 41)
    m.addConstr(18 * x1 + 3 * x3 + 4 * x4 <= 198)
    m.addConstr(28 * x0 + 4 * x4 <= 60)
    m.addConstr(10 * x2 + 3 * x3 <= 85)

    # Protein Constraints
    m.addConstr(11 * x2 + 15 * x3 >= 24)
    m.addConstr(24 * x0 + 6 * x1 >= 28)
    m.addConstr(6 * x1 + 15 * x3 >= 20)
    m.addConstr(6 * x1 + 18 * x4 >= 37)

    # Other Constraints
    m.addConstr(-8 * x2 + 5 * x3 >= 0)
    m.addConstr(11 * x2 + 22 * x3 + 13 * x4 <= 274)

    m.optimize()

    if m.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", m.objVal)
        print("Chicken drumsticks: ", x0.varValue)
        print("Oranges: ", x1.varValue)
        print("Blueberry pies: ", x2.varValue)
        print("Cherry pies: ", x3.varValue)
        print("Strips of bacon: ", x4.varValue)
    else:
        print("No solution found")

create_and_solve_model()
