
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_e = m.addVar(lb=0, name="vitamin_e")  # Milligrams of vitamin E
    vitamin_b6 = m.addVar(lb=0, name="vitamin_b6") # Milligrams of vitamin B6


    # Set objective function
    m.setObjective(3 * vitamin_e + 2 * vitamin_b6, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(1.84 * vitamin_e + 1.53 * vitamin_b6 >= 39, "c1") # Total cardiovascular support index minimum
    m.addConstr(-8 * vitamin_e + 9 * vitamin_b6 >= 0, "c2")      # Constraint on vitamin E and B6 relationship
    m.addConstr(1.84 * vitamin_e + 1.53 * vitamin_b6 <= 44, "c3") # Total cardiovascular support index maximum


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal solution found:")
        print(f"  Milligrams of Vitamin E: {vitamin_e.x}")
        print(f"  Milligrams of Vitamin B6: {vitamin_b6.x}")
        print(f"  Objective Value: {m.objVal}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("Model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
