
from gurobipy import *

# Create a new model
model = Model("Vitamin_Optimization")

# Add variables to the model
x1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_E")
x2 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B6")

# Set the objective function
model.setObjective(3*x1 + 2*x2, GRB.MINIMIZE)

# Add constraints
model.addConstr(1.84*x1 + 1.53*x2 >= 39, "cardiovascular_support_min")
model.addConstr(-8*x1 + 9*x2 >= 0, "vitamin_balance")
model.addConstr(1.84*x1 + 1.53*x2 <= 44, "cardiovascular_support_max")

# Optimize model
model.optimize()

# Print solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin E: {x1.x}")
    print(f"Milligrams of Vitamin B6: {x2.x}")
    print(f"Objective Function Value: {model.ObjVal}")
else:
    print("No optimal solution found")
