
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Add variables
    x1 = model.addVar(name="milligrams_of_vitamin_E", lb=0)  # Assuming non-negativity
    x2 = model.addVar(name="milligrams_of_vitamin_B6", lb=0)  # Assuming non-negativity

    # Objective function: Minimize 3*x1 + 2*x2
    model.setObjective(3*x1 + 2*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(1.84*x1 + 1.53*x2 >= 39, name="cardiovascular_support_index_min")
    model.addConstr(-8*x1 + 9*x2 >= 0, name="vitamin_constraint")
    model.addConstr(1.84*x1 + 1.53*x2 <= 44, name="cardiovascular_support_index_max")

    # Optimize the model
    model.optimize()

    # Print the status
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin E: {x1.varValue}")
        print(f"Milligrams of vitamin B6: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
