
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="x0") # milligrams of vitamin B2
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="x1") # grams of protein
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of potassium
x3 = m.addVar(vtype=gp.GRB.INTEGER, name="x3") # milligrams of vitamin B12
x4 = m.addVar(vtype=gp.GRB.INTEGER, name="x4") # milligrams of zinc


# Set objective function
m.setObjective(5*x0 + 3*x1 + 5*x2 + 4*x3 + 7*x4, gp.GRB.MINIMIZE)

# Add constraints
constraints = [
    (10*x3 + 8*x4 >= 52),
    (13*x2 + 8*x4 >= 49),
    (14*x1 + 10*x3 >= 103),
    # ... (all other constraints as in the JSON)
]

for constraint in constraints:
    m.addConstr(constraint)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

