
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0")  # hours worked by Mary
    x1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1")  # hours worked by George


    # Set objective function
    model.setObjective(x0**2 + 6*x0*x1 + 2*x1**2 + 6*x0 + 8*x1, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(12*x0 + 20*x1 >= 38, "c0")
    model.addConstr(12*x0**2 + 20*x1**2 >= 38, "c1")
    model.addConstr(2*x0 + 12*x1 >= 28, "c2")
    model.addConstr(2*x0**2 + 12*x1**2 >= 28, "c3")
    model.addConstr(-10*x0 + 7*x1 >= 0, "c4")
    model.addConstr(12*x0**2 + 20*x1**2 <= 55, "c5")
    model.addConstr(2*x0 + 12*x1 <= 52, "c6")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
    elif model.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
