
import gurobi

def optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="hours_worked_by_Mary")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="hours_worked_by_George")
    
    # Objective function
    model.setObjective(1*x1**2 + 6*x1*x2 + 2*x2**2 + 6*x1 + 8*x2, gurobi.GRB.MINIMIZE)
    
    # Constraints
    model.addConstr(x1 >= 1, name="Mary_work_quality")
    model.addConstr(x1 >= 1, name="Mary_productivity")
    model.addConstr(x2 >= 1, name="George_work_quality")
    model.addConstr(x2 >= 1, name="George_productivity")
    model.addConstr(144*x1**2 + 400*x2**2 >= 38, name="combined_work_quality_squared")
    model.addConstr(12*x1 + 20*x2 >= 38, name="combined_work_quality")
    model.addConstr(4*x1**2 + 144*x2**2 >= 28, name="combined_productivity_squared")
    model.addConstr(2*x1 + 12*x2 >= 28, name="combined_productivity")
    model.addConstr(-10*x1 + 7*x2 >= 0, name="hour_constraint")
    model.addConstr(144*x1**2 + 400*x2**2 <= 55, name="upper_bound_work_quality_squared")
    model.addConstr(2*x1 + 12*x2 <= 52, name="upper_bound_productivity")
    
    # Optimize
    model.optimize()
    
    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Mary: ", x1.varValue)
        print("Hours worked by George: ", x2.varValue)
    else:
        print("No solution found")

optimization_problem()
