
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=GRB.INTEGER, name="hours worked by Bill")
    x1 = model.addVar(vtype=GRB.CONTINUOUS, name="hours worked by Dale")
    x2 = model.addVar(vtype=GRB.CONTINUOUS, name="hours worked by Mary")


    # Set objective function
    model.setObjective(5*x0**2 + 2*x0*x1 + 4*x0*x2 + 2*x1**2 + 3*x0 + x1, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(5*x0 + 7*x1 + 7*x2 <= 92, "c0")
    model.addConstr(x0 + 6*x1 + 3*x2 <= 34, "c1")
    model.addConstr(7*x1 + 7*x2 >= 13, "c2")
    model.addConstr(5*x0 + 7*x1 >= 28, "c3")
    model.addConstr(6*x1 + 3*x2 >= 8, "c4")
    model.addConstr(x0 + 3*x2 >= 8, "c5")
    model.addConstr(5*x0**2 + 7*x1**2 <= 67, "c6")
    model.addConstr(5*x0 + 7*x2 <= 31, "c7")
    model.addConstr(5*x0 + 7*x1 + 7*x2 <= 31, "c8")
    model.addConstr(x0 + 6*x1 <= 21, "c9")
    model.addConstr(x0 + 6*x1 + 3*x2 <= 21, "c10")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
        print('x2: %g' % x2.x)
    elif model.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
