
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # hours worked by Bill
    x1 = model.addVar(name="x1")  # hours worked by Dale
    x2 = model.addVar(name="x2")  # hours worked by Mary

    # Objective function
    model.setObjective(5*x0**2 + 2*x0*x1 + 4*x0*x2 + 2*x1**2 + 3*x0 + x1, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5*x0 <= 92)
    model.addConstr(x0 <= 34)
    model.addConstr(7*x1 <= 92)
    model.addConstr(6*x1 <= 34)
    model.addConstr(7*x2 <= 92)
    model.addConstr(3*x2 <= 34)
    model.addConstr(7*x1 + 7*x2 >= 13)
    model.addConstr(5*x0 + 7*x1 >= 28)
    model.addConstr(6*x1 + 3*x2 >= 8)
    model.addConstr(x0 + 3*x2 >= 8)
    model.addConstr(25*x0**2 + 49*x1**2 <= 67)
    model.addConstr(5*x0 + 7*x2 <= 31)
    model.addConstr(5*x0 + 7*x1 + 7*x2 <= 31)
    model.addConstr(x0 + 6*x1 <= 21)
    model.addConstr(x0 + 6*x1 + 3*x2 <= 21)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
