
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(6, vtype=gp.GRB.INTEGER, name=["Jean", "Bobby", "Laura", "Hank", "Peggy", "Dale"])

# Set objective function
m.setObjective(2.49 * x[0] + 6.25 * x[1] + 1.54 * x[2] + 3.01 * x[3] + 2.69 * x[4] + 9.45 * x[5], gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(35 * x[0] + 14 * x[1] >= 71)
m.addConstr(5 * x[3] + 34 * x[4] >= 69)
m.addConstr(35 * x[0] + 9 * x[5] >= 69)
m.addConstr(3 * x[1] + 10 * x[5] >= 71)
m.addConstr(14 * x[0] + 10 * x[5] >= 80)
m.addConstr(24 * x[2] + 30 * x[4] >= 106)
m.addConstr(30 * x[4] + 10 * x[5] >= 94)
m.addConstr(3 * x[1] + 24 * x[2] >= 99)
m.addConstr(24 * x[2] + 30 * x[3] >= 115)
m.addConstr(30 * x[3] + 10 * x[5] >= 108)
m.addConstr(24 * x[2] + 10 * x[5] >= 67)
m.addConstr(14 * x[0] + 3 * x[1] + 10 * x[5] >= 72)
m.addConstr(10 * x[0] + 6 * x[3] - x[5] >= 0)
m.addConstr(-5 * x[0] - 7 * x[2] + x[3] >= 0)
m.addConstr(35 * x[0] + 9 * x[5] <= 113)
m.addConstr(34 * x[4] + 9 * x[5] <= 162)
m.addConstr(35 * x[0] + 10 * x[2] <= 441)
m.addConstr(14 * x[1] + 9 * x[5] <= 125)
m.addConstr(10 * x[2] + 34 * x[4] <= 521)
m.addConstr(5 * x[3] + 34 * x[4] <= 533)
m.addConstr(5 * x[3] + 9 * x[5] <= 263)
m.addConstr(35 * x[0] + 14 * x[1] + 10 * x[2] + 5 * x[3] + 34 * x[4] + 9 * x[5] <= 263)
m.addConstr(14 * x[0] + 3 * x[1] <= 573)
m.addConstr(3 * x[1] + 24 * x[2] <= 358)
m.addConstr(14 * x[0] + 10 * x[5] <= 602)
m.addConstr(3 * x[1] + 30 * x[4] <= 632)
m.addConstr(24 * x[2] + 10 * x[5] <= 513)
m.addConstr(24 * x[2] + 30 * x[4] <= 200)
m.addConstr(14 * x[0] + 3 * x[1] + 24 * x[2] <= 352)
m.addConstr(14 * x[0] + 30 * x[4] + 10 * x[5] <= 197)
m.addConstr(14 * x[0] + 30 * x[3] + 30 * x[4] <= 732)
m.addConstr(14 * x[0] + 3 * x[1] + 10 * x[5] <= 502)
m.addConstr(14 * x[0] + 24 * x[2] + 30 * x[3] <= 584)
m.addConstr(24 * x[2] + 30 * x[3] + 30 * x[4] <= 477)
m.addConstr(3 * x[1] + 30 * x[4] + 10 * x[5] <= 515)
m.addConstr(3 * x[1] + 24 * x[2] + 30 * x[4] <= 484)
m.addConstr(14 * x[0] + 3 * x[1] + 30 * x[4] <= 329)
m.addConstr(3 * x[1] + 24 * x[2] + 10 * x[5] <= 360)
m.addConstr(14 * x[0] + 24 * x[2] + 10 * x[5] <= 526)
m.addConstr(14 * x[0] + 3 * x[1] + 24 * x[2] + 30 * x[3] + 30 * x[4] + 10 * x[5] <= 526)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
    print(f'Obj: {m.objVal}')
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

