
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(lb=-gurobi.GRB.INFINITY, name='rotisserie_chickens')
x1 = m.addVar(lb=-gurobi.GRB.INFINITY, name='bowls_of_cereal')
x2 = m.addVar(lb=-gurobi.GRB.INFINITY, name='corn_cobs')
x3 = m.addVar(lb=-gurobi.GRB.INFINITY, name='milkshakes')
x4 = m.addVar(lb=-gurobi.GRB.INFINITY, name='cheeseburgers')
x5 = m.addVar(lb=-gurobi.GRB.INFINITY, name='cantaloupes')

# Objective function
m.setObjective(7.25*x0**2 + 6.35*x0*x1 + 3.97*x1**2 + 2.57*x1*x2 + 9.82*x1*x4 + 9.52*x1*x5 + 10.0*x2*x3 + 3.0*x4*x5 + 1.28*x0 + 9.11*x2 + 5.08*x4, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(16*x0 + 4*x1 + 22*x2 + 8*x3 + x4 + 6*x5 <= 289)
m.addConstr(x0 + 20*x1 + 20*x2 + 17*x3 + 8*x4 + 4*x5 <= 338)
m.addConstr(5*x0 + 19*x1 + 5*x2 + 5*x3 + 17*x4 + 5*x5 <= 275)
m.addConstr(4*x1 + 22*x2 >= 43)
m.addConstr(x2**2 + x4**2 >= 33)
m.addConstr(16*x0 + 22*x2 >= 21)
m.addConstr(4*x1 + 8*x3 >= 24)
m.addConstr(16*x0 + x4 >= 19)
m.addConstr(22*x2 + 6*x5 >= 40)
m.addConstr(x3**2 + x4**2 + x5**2 >= 26)
m.addConstr(16*x0 + 8*x3 + x4 >= 26)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.Status.OPTIMAL:
    print('Objective: ', m.objVal)
    print('x0: ', x0.varValue)
    print('x1: ', x1.varValue)
    print('x2: ', x2.varValue)
    print('x3: ', x3.varValue)
    print('x4: ', x4.varValue)
    print('x5: ', x5.varValue)
else:
    print('No solution found')
