
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="x0")  # milligrams of vitamin B4
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="x1")  # milligrams of vitamin B3
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="x2")  # grams of protein
x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x3") # milligrams of vitamin C


# Set objective function
m.setObjective(9*x0**2 + 6*x0*x1 + 2*x0*x2 + 4*x0*x3 + 8*x1**2 + 9*x1*x2 + 4*x1*x3 + 3*x2**2 + 8*x2*x3 + 8*x3**2 + 8*x0 + 5*x1 + 7*x2 + 9*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(27*x0 + 11*x1 + 15*x2 + 18*x3 <= 238, "r0")
m.addConstr(1*x0 + 26*x1 + 15*x2 + 2*x3 <= 272, "r1")
m.addConstr(27*x0 + 11*x1 >= 19, "c1")
m.addConstr(11*x1 + 15*x2 >= 24, "c2")
m.addConstr(11*x1 + 18*x3 >= 29, "c3")
m.addConstr(27*x0 + 15*x2 >= 33, "c4")
m.addConstr(27*x0 + 15*x2 + 18*x3 >= 56, "c5")
m.addConstr(27*x0 + 11*x1 + 15*x2 >= 56, "c6")
m.addConstr(27*x0 + 15*x2 + 18*x3 >= 54, "c7")
m.addConstr(27*x0 + 11*x1 + 15*x2 >= 54, "c8")
m.addConstr(27*x0 + 11*x1 + 15*x2 + 18*x3 >= 54, "c9")
m.addConstr(1*x0 + 15*x2 >= 38, "c10")
m.addConstr(15*x2 + 2*x3 >= 56, "c11")
m.addConstr(1*x0 + 26*x1 + 2*x3 >= 53, "c12")
m.addConstr(1*x0 + 26*x1 + 15*x2 + 2*x3 >= 53, "c13")
m.addConstr(7*x2**2 - 4*x3**2 >= 0, "c14")
m.addConstr(-10*x0 + 9*x3 >= 0, "c15")
m.addConstr(15*x2**2 + 18*x3**2 <= 108, "c16")
m.addConstr(27*x0 + 18*x3 <= 207, "c17")
m.addConstr(11*x1 + 15*x2 <= 121, "c18")
m.addConstr(27*x0 + 15*x2 <= 118, "c19")
m.addConstr(27*x0 + 15*x2 + 18*x3 <= 80, "c20")
m.addConstr(27*x0 + 11*x1 + 18*x3 <= 151, "c21")


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('The problem is unbounded or has another status.')

