
from gurobipy import *

# Create a new model
m = Model("optimization_problem")

# Create variables
x = {}
item_names = ['postage stamps', 'manila envelopes', '3D printers', 'packs of paper', 'lanyards', 'paper clips', 'red pens', 'color printers']
for i in range(len(item_names)):
    x[i] = m.addVar(vtype=GRB.INTEGER, name=item_names[i])

# Set objective function
m.setObjective(8*x[0] + 7*x[1] + 5*x[2] + 5*x[3] + 9*x[4] + 8*x[5] + 2*x[6] + 1*x[7], GRB.MAXIMIZE)

# Add usefulness rating and weight constraints
usefulness = {'x0': 13, 'x1': 7, 'x2': 1, 'x3': 6, 'x4': 8, 'x5': 8, 'x6': 11, 'x7': 6}
weight = {'x0': 5, 'x1': 2, 'x2': 6, 'x3': 3, 'x4': 5, 'x5': 2, 'x6': 9, 'x7': 11}

r0 = quicksum(usefulness[f'x{i}'] * x[i] for i in range(len(item_names)))
r1 = quicksum(weight[f'x{i}'] * x[i] for i in range(len(item_names)))

m.addConstr(r0 <= 296)
m.addConstr(r1 <= 214)


# Add other constraints from JSON "constraints"
constraints_json = {
  "sym_variables": [
    ("x0", "postage stamps"),
    ("x1", "manila envelopes"),
    ("x2", "3D printers"),
    ("x3", "packs of paper"),
    ("x4", "lanyards"),
    ("x5", "paper clips"),
    ("x6", "red pens"),
    ("x7", "color printers")
  ],
    "objective_function": "8*x0 + 7*x1 + 5*x2 + 5*x3 + 9*x4 + 8*x5 + 2*x6 + 1*x7",
    "constraints": [
    # ... (Insert constraints from JSON here)
    ]
}

for constraint_str in constraints_json["constraints"]:
    m.addConstr(eval(constraint_str))


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print(f"Optimization ended with status {m.status}")

