
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="postage_stamps", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="manila_envelopes", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="3D_printers", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="packs_of_paper", vtype=gurobi.GRB.INTEGER)
    x4 = model.addVar(name="lanyards", vtype=gurobi.GRB.INTEGER)
    x5 = model.addVar(name="paper_clips", vtype=gurobi.GRB.INTEGER)
    x6 = model.addVar(name="red_pens", vtype=gurobi.GRB.INTEGER)
    x7 = model.addVar(name="color_printers", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(8*x0 + 7*x1 + 5*x2 + 5*x3 + 9*x4 + 8*x5 + 2*x6 + 1*x7, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(13*x0 <= 296)
    model.addConstr(7*x1 <= 296)
    model.addConstr(x2 <= 296)
    model.addConstr(6*x3 <= 296)
    model.addConstr(8*x4 <= 296)
    model.addConstr(8*x5 <= 296)
    model.addConstr(11*x6 <= 296)
    model.addConstr(6*x7 <= 296)

    model.addConstr(5*x0 <= 214)
    model.addConstr(2*x1 <= 214)
    model.addConstr(6*x2 <= 214)
    model.addConstr(3*x3 <= 214)
    model.addConstr(5*x4 <= 214)
    model.addConstr(2*x5 <= 214)
    model.addConstr(9*x6 <= 214)
    model.addConstr(11*x7 <= 214)

    model.addConstr(13*x0 + x2 >= 16)
    model.addConstr(7*x1 + 8*x5 >= 19)
    model.addConstr(8*x4 + 11*x6 >= 18)
    model.addConstr(13*x0 + 8*x4 >= 17)
    model.addConstr(7*x1 + 6*x3 >= 19)
    model.addConstr(6*x3 + 8*x4 >= 21)
    model.addConstr(6*x3 + 8*x5 >= 18)
    model.addConstr(8*x5 + 6*x7 >= 13)

    model.addConstr(7*x1 + 6*x3 + 8*x4 >= 24)
    model.addConstr(13*x0 + x2 + 8*x5 >= 24)
    model.addConstr(13*x0 + 7*x1 + 11*x6 >= 24)
    model.addConstr(7*x1 + 8*x5 + 6*x7 >= 24)
    model.addConstr(6*x3 + 8*x4 + 6*x7 >= 24)
    model.addConstr(8*x4 + 11*x6 + 6*x7 >= 24)
    model.addConstr(x2 + 8*x5 + 11*x6 >= 24)
    model.addConstr(7*x1 + x2 + 6*x3 >= 24)
    model.addConstr(7*x1 + x2 + 6*x7 >= 24)
    model.addConstr(13*x0 + x2 + 6*x7 >= 24)
    model.addConstr(6*x3 + 8*x5 + 8*x7 >= 24)
    model.addConstr(x2 + 6*x3 + 8*x5 >= 24)
    model.addConstr(13*x0 + 8*x5 + 6*x7 >= 24)
    model.addConstr(13*x0 + 6*x3 + 8*x4 >= 24)
    model.addConstr(13*x0 + 7*x1 + 8*x4 >= 24)
    model.addConstr(7*x1 + 8*x4 + 6*x7 >= 24)

    model.addConstr(x0 >= 0)
    model.addConstr(x1 >= 0)
    model.addConstr(x2 >= 0)
    model.addConstr(x3 >= 0)
    model.addConstr(x4 >= 0)
    model.addConstr(x5 >= 0)
    model.addConstr(x6 >= 0)
    model.addConstr(x7 >= 0)

    model.addConstr(x0 % 1 == 0)
    model.addConstr(x1 % 1 == 0)
    model.addConstr(x2 % 1 == 0)
    model.addConstr(x3 % 1 == 0)
    model.addConstr(x4 % 1 == 0)
    model.addConstr(x5 % 1 == 0)
    model.addConstr(x6 % 1 == 0)
    model.addConstr(x7 % 1 == 0)

    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objval)
        print("Postage stamps: ", x0.varValue)
        print("Manila envelopes: ", x1.varValue)
        print("3D printers: ", x2.varValue)
        print("Packs of paper: ", x3.varValue)
        print("Lanyards: ", x4.varValue)
        print("Paper clips: ", x5.varValue)
        print("Red pens: ", x6.varValue)
        print("Color printers: ", x7.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
