
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    pen_testers = m.addVar(vtype=gp.GRB.INTEGER, name="pen_testers")
    intrusion_analysts = m.addVar(vtype=gp.GRB.INTEGER, name="intrusion_analysts")

    # Set objective function
    m.setObjective(5.33*pen_testers**2 + 7.9*intrusion_analysts**2 + 3.3*pen_testers, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(15*pen_testers + 18*intrusion_analysts <= 129, "power_consumption")
    m.addConstr(10*pen_testers + 7*intrusion_analysts <= 176, "dollar_cost")
    m.addConstr(8*pen_testers + 7*intrusion_analysts <= 244, "network_latency")
    m.addConstr(13*pen_testers + 6*intrusion_analysts <= 309, "data_confidentiality")
    m.addConstr(9*pen_testers + 20*intrusion_analysts <= 192, "network_integrity")
    m.addConstr(15*pen_testers**2 + 18*intrusion_analysts**2 >= 22, "power_consumption_squared")
    m.addConstr(10*pen_testers + 7*intrusion_analysts >= 63, "min_dollar_cost")
    m.addConstr(8*pen_testers + 7*intrusion_analysts >= 88, "min_network_latency")
    m.addConstr(13*pen_testers + 6*intrusion_analysts >= 81, "min_data_confidentiality")
    m.addConstr(9*pen_testers + 20*intrusion_analysts >= 91, "min_network_integrity")
    m.addConstr(9*pen_testers - 3*intrusion_analysts >= 0, "linear_constraint")
    m.addConstr(15*pen_testers + 18*intrusion_analysts <= 68, "max_power_consumption")
    m.addConstr(10*pen_testers**2 + 7*intrusion_analysts**2 <= 143, "max_dollar_cost_squared")
    m.addConstr(10*pen_testers + 7*intrusion_analysts <= 143, "max_dollar_cost")
    m.addConstr(8*pen_testers + 7*intrusion_analysts <= 213, "max_network_latency")
    m.addConstr(13*pen_testers + 6*intrusion_analysts <= 157, "max_data_confidentiality")
    m.addConstr(9*pen_testers**2 + 20*intrusion_analysts**2 <= 192, "max_network_integrity_squared")


    # Optimize model
    m.optimize()

    # Print solution
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('pen_testers:', pen_testers.x)
        print('intrusion_analysts:', intrusion_analysts.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
