
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="pen_testers", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="intrusion_analysts", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(5.33 * x1**2 + 7.9 * x2**2 + 3.3 * x1, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(15 * x1 + 18 * x2 <= 129, name="power_consumption")
m.addConstr(10 * x1 + 7 * x2 <= 176, name="dollar_cost")
m.addConstr(8 * x1 + 7 * x2 <= 213, name="network_latency")
m.addConstr(13 * x1 + 6 * x2 <= 157, name="data_confidentiality_impact")
m.addConstr(9 * x1 + 20 * x2 <= 192, name="network_integrity_impact")
m.addConstr(225 * x1**2 + 324 * x2**2 >= 22, name="min_power_consumption_squared")
m.addConstr(10 * x1 + 7 * x2 >= 63, name="min_dollar_cost")
m.addConstr(8 * x1 + 7 * x2 >= 88, name="min_network_latency")
m.addConstr(13 * x1 + 6 * x2 >= 81, name="min_data_confidentiality_impact")
m.addConstr(9 * x1 + 20 * x2 >= 91, name="min_network_integrity_impact")
m.addConstr(9 * x1 - 3 * x2 >= 0, name="pen_testers_vs_intrusion_analysts")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Pen testers: ", x1.varValue)
    print("Intrusion analysts: ", x2.varValue)
else:
    print("The model is infeasible")
