
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x0")
    x1 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x1")
    x2 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x2")


    # Set objective function
    model.setObjective(7*x0 + 4*x1 + 1*x2, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(4*x0 + 7*x1 >= 19, "c1")
    model.addConstr(4*x0 + 2*x2 >= 18, "c2")
    model.addConstr(7*x1 + 2*x2 >= 8, "c3")
    model.addConstr(4*x0 + 7*x1 + 2*x2 >= 8, "c4")
    model.addConstr(7*x0 + 2*x1 >= 15, "c5")
    model.addConstr(7*x0 + 1*x2 >= 8, "c6")
    model.addConstr(7*x0 + 2*x1 + 1*x2 >= 8, "c7")
    model.addConstr(3*x0 + 5*x1 >= 17, "c8")
    model.addConstr(5*x1 + 5*x2 >= 6, "c9")
    model.addConstr(3*x0 + 5*x1 + 5*x2 >= 6, "c10")
    model.addConstr(5*x1 - 9*x2 >= 0, "c11")
    model.addConstr(-6*x0 + 2*x1 >= 0, "c12")
    model.addConstr(4*x0 + 2*x2 <= 46, "c13")
    model.addConstr(3*x0 + 5*x1 <= 20, "c14")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
