
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Ringo
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Laura
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Mary

    # Define the objective function
    model.setObjective(7 * x0 + 4 * x1 + x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(4 * x0 <= 60)
    model.addConstr(7 * x0 <= 63)
    model.addConstr(3 * x0 <= 59)
    model.addConstr(7 * x1 <= 60)
    model.addConstr(2 * x1 <= 63)
    model.addConstr(5 * x1 <= 59)
    model.addConstr(2 * x2 <= 60)
    model.addConstr(x2 <= 63)
    model.addConstr(5 * x2 <= 59)
    model.addConstr(4 * x0 + 7 * x1 >= 19)
    model.addConstr(4 * x0 + 2 * x2 >= 18)
    model.addConstr(7 * x1 + 2 * x2 >= 8)
    model.addConstr(4 * x0 + 7 * x1 + 2 * x2 >= 8)
    model.addConstr(7 * x0 + 2 * x1 >= 15)
    model.addConstr(7 * x0 + x2 >= 8)
    model.addConstr(7 * x0 + 2 * x1 + x2 >= 8)
    model.addConstr(3 * x0 + 5 * x1 >= 17)
    model.addConstr(5 * x1 + 5 * x2 >= 6)
    model.addConstr(3 * x0 + 5 * x1 + 5 * x2 >= 6)
    model.addConstr(5 * x1 - 9 * x2 >= 0)
    model.addConstr(-6 * x0 + 2 * x1 >= 0)
    model.addConstr(4 * x0 + 2 * x2 <= 46)
    model.addConstr(3 * x0 + 5 * x1 <= 20)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Ringo: ", x0.varValue)
        print("Hours worked by Laura: ", x1.varValue)
        print("Hours worked by Mary: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
