
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
milkshakes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milkshakes")
chicken_thighs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_thighs")
oreos = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oreos")
granola_bars = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="granola_bars")

# Set objective function
m.setObjective(6 * milkshakes + 2 * chicken_thighs + 8 * oreos + 6 * granola_bars, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * chicken_thighs + 6 * granola_bars >= 36)
m.addConstr(7 * oreos + 6 * granola_bars >= 36)
m.addConstr(4 * milkshakes + 6 * chicken_thighs + 6 * granola_bars >= 18)
m.addConstr(9 * milkshakes + 10 * granola_bars >= 25)
m.addConstr(7 * oreos + 6 * granola_bars <= 88)
m.addConstr(4 * milkshakes + 6 * granola_bars <= 131)
m.addConstr(4 * milkshakes + 6 * chicken_thighs <= 116)
m.addConstr(6 * chicken_thighs + 6 * granola_bars <= 137)
m.addConstr(4 * milkshakes + 6 * chicken_thighs + 7 * oreos <= 49)
m.addConstr(4 * milkshakes + 7 * oreos + 6 * granola_bars <= 105)
m.addConstr(4 * milkshakes + 6 * chicken_thighs + 7 * oreos + 6 * granola_bars <= 105)
m.addConstr(9 * milkshakes + 10 * granola_bars <= 40)
m.addConstr(7 * chicken_thighs + 10 * granola_bars <= 45)
m.addConstr(9 * milkshakes + 2 * oreos <= 87)
m.addConstr(9 * milkshakes + 2 * oreos + 10 * granola_bars <= 47)
m.addConstr(9 * milkshakes + 7 * chicken_thighs + 2 * oreos + 10 * granola_bars <= 47)

# Resource Constraints
m.addConstr(4 * milkshakes <= 144)
m.addConstr(6 * chicken_thighs <= 144)
m.addConstr(7 * oreos <= 144)
m.addConstr(6 * granola_bars <= 144)
m.addConstr(9 * milkshakes + 7 * chicken_thighs + 2 * oreos + 10 * granola_bars <= 134)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

