
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="milkshakes", lb=0)
x1 = model.addVar(name="chicken_thighs", lb=0)
x2 = model.addVar(name="oreos", lb=0)
x3 = model.addVar(name="granola_bars", lb=0)

# Define the objective function
model.setObjective(6 * x0 + 2 * x1 + 8 * x2 + 6 * x3, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(4 * x0 + 6 * x1 + 7 * x2 + 6 * x3 <= 144)  # protein constraint
model.addConstr(9 * x0 + 7 * x1 + 2 * x2 + 10 * x3 <= 134)  # cost constraint
model.addConstr(6 * x1 + 6 * x3 >= 36)  # protein from chicken thighs and granola bars
model.addConstr(7 * x2 + 6 * x3 >= 36)  # protein from oreos and granola bars
model.addConstr(4 * x0 + 6 * x1 + 6 * x3 >= 18)  # protein from milkshakes, chicken thighs, and granola bars
model.addConstr(9 * x0 + 10 * x3 >= 25)  # minimum spend on milkshakes and granola bars
model.addConstr(7 * x2 + 6 * x3 <= 88)  # max protein from oreos and granola bars
model.addConstr(4 * x0 + 6 * x3 <= 131)  # max protein from milkshakes and granola bars
model.addConstr(4 * x0 + 6 * x1 <= 116)  # max protein from milkshakes and chicken thighs
model.addConstr(6 * x1 + 6 * x3 <= 137)  # max protein from chicken thighs and granola bars
model.addConstr(4 * x0 + 6 * x1 + 7 * x2 <= 49)  # max protein from milkshakes, chicken thighs, and oreos
model.addConstr(4 * x0 + 7 * x2 + 6 * x3 <= 105)  # max protein from milkshakes, oreos, and granola bars
model.addConstr(4 * x0 + 6 * x1 + 7 * x2 + 6 * x3 <= 105)  # max protein from all
model.addConstr(9 * x0 + 10 * x3 <= 40)  # max spend on milkshakes and granola bars
model.addConstr(7 * x1 + 10 * x3 <= 45)  # max spend on chicken thighs and granola bars
model.addConstr(9 * x0 + 2 * x2 <= 87)  # max spend on milkshakes and oreos
model.addConstr(9 * x0 + 2 * x2 + 10 * x3 <= 47)  # max spend on milkshakes, oreos, and granola bars
model.addConstr(9 * x0 + 7 * x1 + 2 * x2 + 10 * x3 <= 47)  # max spend on all

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Milkshakes: ", x0.x)
    print("Chicken Thighs: ", x1.x)
    print("Oreos: ", x2.x)
    print("Granola Bars: ", x3.x)
else:
    print("The model is infeasible")
