
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name='rotisserie_chickens', lb=0, ub=None)
    x1 = model.addVar(name='strawberries', lb=0, ub=None)
    x2 = model.addVar(name='kale_salads', lb=0, ub=None)

    # Define the objective function
    model.setObjective(1.86 * x0**2 + 3.99 * x0 * x1 + 3.25 * x0 * x2 + 9.37 * x1 * x2 + 9.46 * x2**2 + 3.19 * x1 + 5.67 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x0 + 13 * x1 + 6 * x2 <= 122, name='protein_constraint')
    model.addConstr(8 * x0 + 6 * x1 + 9 * x2 <= 117, name='calcium_constraint')
    model.addConstr(x0**2 + x1**2 >= 16, name='protein_rotisserie_strawberries')
    model.addConstr(x0**2 + x2**2 <= 118, name='protein_rotisserie_kale')
    model.addConstr(x0 + 13 * x1 + 6 * x2 <= 118, name='total_protein')
    model.addConstr(8 * x0 + 6 * x1 <= 117, name='calcium_rotisserie_strawberries')
    model.addConstr(6 * x1 + 9 * x2 <= 82, name='calcium_strawberries_kale')
    model.addConstr(8 * x0 + 9 * x2 <= 117, name='calcium_rotisserie_kale')
    model.addConstr(8 * x0 + 6 * x1 + 9 * x2 <= 117, name='total_calcium')

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('Rotisserie chickens: ', x0.varValue)
        print('Strawberries: ', x1.varValue)
        print('Kale salads: ', x2.varValue)
    else:
        print('No optimal solution found')

solve_optimization_problem()
