
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="ham sandwiches")
x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="potatoes")
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="tomatoes")
x3 = m.addVar(vtype=gp.GRB.INTEGER, name="blueberry pies")
x4 = m.addVar(vtype=gp.GRB.INTEGER, name="milkshakes")


# Set objective function
m.setObjective(3.25 * x0 + 8.27 * x1 + 4.04 * x2 + 2.37 * x3 + 2.22 * x4, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(x2 + 7 * x3 >= 16)
m.addConstr(19 * x0 + x2 >= 42)
m.addConstr(8 * x1 + x2 >= 34)
m.addConstr(7 * x3 + 3 * x4 >= 21)
m.addConstr(8 * x1 + 3 * x4 >= 17)
m.addConstr(x2 + 3 * x4 >= 43)
m.addConstr(8 * x1 + 7 * x3 >= 30)
m.addConstr(19 * x0 + 3 * x4 >= 34)
# ... (add all other constraints similarly)
m.addConstr(19 * x0 + 8 * x1 + x2 + 7 * x3 + 3 * x4 <= 227)
m.addConstr(11 * x0 + 23 * x1 + 17 * x2 + 3 * x3 + 12 * x4 <= 212)
m.addConstr(5 * x0 + 10 * x1 + 19 * x2 + 13 * x3 + 14 * x4 <= 214)
m.addConstr(11 * x0 + 17 * x1 + 2 * x2 + x3 + 20 * x4 <= 358)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

