
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
x = m.addVars(6, lb=0, vtype=gp.GRB.CONTINUOUS, name=["zinc", "vitamin_B5", "vitamin_B12", "fat", "vitamin_C", "calcium"])


# Set objective function
m.setObjective(4.47 * x[0] + 5.59 * x[1] + 8.57 * x[2] + 1.33 * x[3] + 2.5 * x[4] + 6.77 * x[5], gp.GRB.MAXIMIZE)

# Cardiovascular support index constraints
cardio_constraints = [
    (6, 9, 0, 0, 22, 0, 228),  # r0 constraint
    (14, 21, 0, 0, 1, 0, 503)   # r1 constraint

]

for i, (zinc_coeff, b5_coeff, b12_coeff, fat_coeff, c_coeff, calcium_coeff, rhs) in enumerate(cardio_constraints):
    m.addConstr(zinc_coeff * x[0] + b5_coeff * x[1] + b12_coeff * x[2] + fat_coeff * x[3] + c_coeff * x[4] + calcium_coeff * x[5] <= rhs, f"cardio_{i}")


# Add other constraints as provided in the prompt, substituting variable names
m.addConstr(6*x[0] + 9*x[1] + 22*x[4] >= 37)
m.addConstr(6*x[0] + 9*x[1] + 22*x[5] >= 37)
m.addConstr(9*x[1] + 22*x[4] + 22*x[5] >= 37)
m.addConstr(15*x[2] + 9*x[3] + 22*x[5] >= 37)
m.addConstr(6*x[0] + 9*x[3] + 22*x[4] >= 37)

# ... (add all other constraints similarly)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print(f"Optimization ended with status {m.status}")

