
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
oreos = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oreos")
bacon = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bacon")
cheeseburgers = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cheeseburgers")
cherry_pies = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cherry_pies")


# Set objective function
m.setObjective(9.32 * oreos + 7.86 * bacon + 6.97 * cheeseburgers + 5.41 * cherry_pies, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(1.37 * oreos + 0.58 * bacon + 2.62 * cheeseburgers + 1.27 * cherry_pies <= 193, "c0")
m.addConstr(2.7 * oreos + 2.19 * bacon + 1.36 * cheeseburgers + 1.67 * cherry_pies <= 399, "c1")
m.addConstr(1.37 * oreos + 0.58 * bacon >= 18, "c2")
m.addConstr(0.58 * bacon + 1.27 * cherry_pies >= 40, "c3")
m.addConstr(1.37 * oreos + 2.62 * cheeseburgers >= 31, "c4")
m.addConstr(1.37 * oreos + 1.27 * cherry_pies >= 23, "c5")
m.addConstr(0.58 * bacon + 2.62 * cheeseburgers >= 39, "c6")
m.addConstr(1.37 * oreos + 0.58 * bacon + 2.62 * cheeseburgers + 1.27 * cherry_pies >= 39, "c7")
m.addConstr(2.19 * bacon + 1.36 * cheeseburgers >= 33, "c8")
m.addConstr(2.7 * oreos + 1.67 * cherry_pies >= 98, "c9")
m.addConstr(2.7 * oreos + 1.36 * cheeseburgers >= 61, "c10")
m.addConstr(1.36 * cheeseburgers + 1.67 * cherry_pies >= 44, "c11")
m.addConstr(2.7 * oreos + 2.19 * bacon + 1.36 * cheeseburgers + 1.67 * cherry_pies >= 44, "c12")
m.addConstr(10 * oreos - 6 * cheeseburgers >= 0, "c13")
m.addConstr(-8 * oreos + 9 * bacon >= 0, "c14")
m.addConstr(2.62 * cheeseburgers + 1.27 * cherry_pies <= 161, "c15")
m.addConstr(2.7 * oreos + 2.19 * bacon + 1.67 * cherry_pies <= 227, "c16")
m.addConstr(2.7 * oreos + 2.19 * bacon + 1.36 * cheeseburgers <= 305, "c17")
m.addConstr(2.7 * oreos + 1.36 * cheeseburgers + 1.67 * cherry_pies <= 384, "c18")
m.addConstr(2.19 * bacon + 1.36 * cheeseburgers + 1.67 * cherry_pies <= 200, "c19")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

