
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name='oreos', lb=0)
x2 = model.addVar(name='strips of bacon', lb=0)
x3 = model.addVar(name='cheeseburgers', lb=0)
x4 = model.addVar(name='cherry pies', lb=0)

# Define the objective function
model.setObjective(9.32*x1 + 7.86*x2 + 6.97*x3 + 5.41*x4, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(1.37*x1 + 0.58*x2 + 2.62*x3 + 1.27*x4 <= 193)
model.addConstr(2.7*x1 + 2.19*x2 + 1.36*x3 + 1.67*x4 <= 399)
model.addConstr(1.37*x1 + 0.58*x2 >= 18)
model.addConstr(0.58*x2 + 1.27*x4 >= 40)
model.addConstr(1.37*x1 + 2.62*x3 >= 31)
model.addConstr(1.37*x1 + 1.27*x4 >= 23)
model.addConstr(0.58*x2 + 2.62*x3 >= 39)
model.addConstr(1.37*x1 + 0.58*x2 + 2.62*x3 + 1.27*x4 >= 39)
model.addConstr(2.19*x2 + 1.36*x3 >= 33)
model.addConstr(2.7*x1 + 1.67*x4 >= 98)
model.addConstr(2.7*x1 + 1.36*x3 >= 61)
model.addConstr(1.36*x3 + 1.67*x4 >= 44)
model.addConstr(2.7*x1 + 2.19*x2 + 1.36*x3 + 1.67*x4 >= 44)
model.addConstr(10*x1 - 6*x3 >= 0)
model.addConstr(-8*x1 + 9*x2 >= 0)
model.addConstr(2.62*x3 + 1.27*x4 <= 161)
model.addConstr(2.7*x1 + 2.19*x2 + 1.67*x4 <= 227)
model.addConstr(2.7*x1 + 2.19*x2 + 1.36*x3 <= 305)
model.addConstr(2.7*x1 + 1.36*x3 + 1.67*x4 <= 384)
model.addConstr(2.19*x2 + 1.36*x3 + 1.67*x4 <= 200)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objVal)
    print('Oreos: ', x1.varValue)
    print('Strips of bacon: ', x2.varValue)
    print('Cheeseburgers: ', x3.varValue)
    print('Cherry pies: ', x4.varValue)
else:
    print('No optimal solution found')
