
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x = m.addVars(4, lb=0, vtype=gp.GRB.CONTINUOUS, names=["x0", "x1", "x2", "x3"])


    # Set objective function
    m.setObjective(2*x[0] + 9*x[1] + 9*x[2] + 9*x[3], gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(12.0*x[0] + 11.55*x[3] >= 51)
    m.addConstr(14.36*x[1] + 12.39*x[2] >= 41)
    m.addConstr(12.0*x[0] + 12.39*x[2] + 11.55*x[3] >= 72)
    m.addConstr(12.0*x[0] + 14.36*x[1] + 12.39*x[2] >= 72)
    m.addConstr(14.36*x[1] + 12.39*x[2] + 11.55*x[3] >= 72)
    m.addConstr(12.0*x[0] + 12.39*x[2] + 11.55*x[3] >= 52)
    m.addConstr(12.0*x[0] + 14.36*x[1] + 12.39*x[2] >= 52)
    m.addConstr(14.36*x[1] + 12.39*x[2] + 11.55*x[3] >= 52)
    m.addConstr(12.0*x[0] + 12.39*x[2] + 11.55*x[3] >= 80)
    m.addConstr(12.0*x[0] + 14.36*x[1] + 12.39*x[2] >= 80)
    m.addConstr(14.36*x[1] + 12.39*x[2] + 11.55*x[3] >= 80)
    m.addConstr(0.68*x[1] + 10.72*x[3] >= 44)
    m.addConstr(6.74*x[0] + 3.27*x[2] >= 43)
    m.addConstr(0.02*x[1] + 4.19*x[2] >= 19)
    m.addConstr(4.16*x[0] + 0.02*x[1] >= 42)
    m.addConstr(4.16*x[0] + 4.19*x[2] >= 48)
    m.addConstr(4.16*x[0] + 11.26*x[3] >= 31)
    m.addConstr(4.19*x[2] + 11.26*x[3] >= 41)
    m.addConstr(12.0*x[0] + 11.55*x[3] <= 272)
    m.addConstr(12.39*x[2] + 11.55*x[3] <= 319)
    m.addConstr(14.36*x[1] + 11.55*x[3] <= 119)
    m.addConstr(12.0*x[0] + 12.39*x[2] <= 228)
    m.addConstr(12.0*x[0] + 14.36*x[1] + 12.39*x[2] + 11.55*x[3] <= 228)
    m.addConstr(6.74*x[0] + 0.68*x[1] <= 186)
    m.addConstr(6.74*x[0] + 3.27*x[2] <= 121)
    m.addConstr(3.27*x[2] + 10.72*x[3] <= 136)
    m.addConstr(0.68*x[1] + 3.27*x[2] <= 127)
    m.addConstr(6.74*x[0] + 3.27*x[2] + 10.72*x[3] <= 117)
    m.addConstr(0.68*x[1] + 3.27*x[2] + 10.72*x[3] <= 168)
    m.addConstr(6.74*x[0] + 0.68*x[1] + 3.27*x[2] + 10.72*x[3] <= 168)
    m.addConstr(3.54*x[2] + 14.05*x[3] <= 94)
    m.addConstr(5.9*x[1] + 3.54*x[2] <= 64)
    m.addConstr(13.06*x[0] + 5.9*x[1] <= 38)
    m.addConstr(13.06*x[0] + 14.05*x[3] <= 118)
    m.addConstr(5.9*x[1] + 14.05*x[3] <= 64)
    m.addConstr(13.06*x[0] + 5.9*x[1] + 3.54*x[2] + 14.05*x[3] <= 64)
    m.addConstr(4.16*x[0] + 11.26*x[3] <= 119)
    m.addConstr(0.02*x[1] + 4.19*x[2] <= 124)
    m.addConstr(4.16*x[0] + 0.02*x[1] + 4.19*x[2] + 11.26*x[3] <= 124)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
        print(f'Objective Value: {m.objVal}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
