
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="potatoes", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x2 = m.addVar(name="milkshakes", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x3 = m.addVar(name="protein_bars", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x4 = m.addVar(name="hot_dogs", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)

# Define the objective function
m.setObjective(5.19*x1**2 + 6.13*x1*x2 + 5.47*x1*x3 + 9.83*x1*x4 + 7.3*x2**2 + 4.72*x2*x3 + 3.82*x3**2 + 8.95*x4**2 + 6.59*x1 + 6.2*x4, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x1 <= 158, name="potatoes_tastiness")
m.addConstr(8*x2 <= 158, name="milkshakes_tastiness")
m.addConstr(x3 <= 158, name="protein_bars_tastiness")
m.addConstr(4*x4 <= 158, name="hot_dogs_tastiness")
m.addConstr(9*x1**2 + x3**2 >= 30, name="potatoes_protein_bars_tastiness")
m.addConstr(8*x2 + 4*x4 >= 28, name="milkshakes_hot_dogs_tastiness")
m.addConstr(3*x1 + 8*x2 + x3 + 4*x4 >= 28, name="all_tastiness")
m.addConstr(3*x1 + x3 <= 61, name="potatoes_protein_bars_tastiness_limit")
m.addConstr(3*x1 + 8*x2 <= 62, name="potatoes_milkshakes_tastiness_limit")
m.addConstr(3*x1 + 4*x4 <= 127, name="potatoes_hot_dogs_tastiness_limit")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Potatoes: {x1.varValue}")
    print(f"Milkshakes: {x2.varValue}")
    print(f"Protein Bars: {x3.varValue}")
    print(f"Hot Dogs: {x4.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
