
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="x0") # milligrams of vitamin B1
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="x1") # grams of protein
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # grams of fiber

# Set objective function
m.setObjective(7*x0**2 + 9*x0*x1 + 4*x0*x2 + 4*x1**2 + 8*x1*x2 + x2**2 + 8*x0 + 4*x1 + x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9*x0 + 7*x1 + 10*x2 <= 93, "r0_upper_bound")
m.addConstr(9*x0 + 10*x2 >= 16, "c1")
m.addConstr(9*x0 + 7*x1 >= 19, "c2")
m.addConstr(9*x0 + 7*x1 + 10*x2 >= 19, "c3")
m.addConstr(81*x0**2 + 49*x1**2 + 100*x2**2 <= 73, "c4")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal objective value:", m.objVal)
    print("x0 =", x0.x)
    print("x1 =", x1.x)
    print("x2 =", x2.x)

